/***
 * DateSelector: Changes date/&time input with select box.
 * Value is set on the desired input, once complete date is set.
 * Version: 0.6
 * Last updated: 01.2014
 *
 * Copyright (c) 2014 eg81.es
 * http://eg81.es/dateSelector/
 * minified with http://javascript-minifier.com/ 
 */
 !function(t){t.fn.dateSelector=function(e){var a=this,r=t.extend(!0,{dateformat:"H:i:s d-m-Y",alertIncorrectDay:"Select a correct day!",checkIncomplete:!0,alertIncomplete:"Date incomplete!",firstOptionClass:"first-option",dateContainerTag:"",dateContainerClass:"",dateContainerSeparator:!0,timeContainerTag:"",timeContainerClass:"",timeContainerSeparator:!0,dayAttr:{selected:0,"class":"",size:1,blankTxt:"",blankVal:"",beforeTag:"&nbsp;",afterTag:"&nbsp;"},monthAttr:{selected:0,"class":"",size:1,blankTxt:"",blankVal:"",names:{1:"January",2:"February",3:"March",4:"April",5:"May",6:"June",7:"July",8:"August",9:"September",10:"October",11:"November",12:"December"},beforeTag:"&nbsp;",afterTag:"&nbsp;"},yearAttr:{selected:0,"class":"",size:1,blankTxt:"",blankVal:"",start:(new Date).getFullYear(),end:(new Date).getFullYear()+5,beforeTag:"&nbsp;",afterTag:"&nbsp;"},hourAttr:{selected:null,"class":"",size:1,blankTxt:"",blankVal:"",beforeTag:"&nbsp;",afterTag:"&nbsp;",factor:""},minAttr:{selected:null,"class":"",size:1,blankTxt:"",blankVal:"",beforeTag:"&nbsp;",afterTag:"&nbsp;",factor:""},secAttr:{selected:null,"class":"",size:1,blankTxt:"",blankVal:"",beforeTag:"&nbsp;",afterTag:"&nbsp;",factor:""}},e);t.fn.dateSelectorDayOptions=function(t){var e,a,n,s="";for(e=r.dayAttr.selected,a=r.dayAttr.blankTxt,n=r.dayAttr.blankVal,i=0;t>=i;i++){var l="",o=i==e?" selected":"",d=10>i?"0"+i:i,c=10>i?"0"+i:i;0==i&&(c=a,d=n,o=' cass="'+r.firstOptionClass+'"'+o),l='<option value="'+d+'"'+o+">"+c+"</option>\n",s+=l}return s},t.fn.dateSelectorMonthOptions=function(){var t,e,a,n="";for(t=r.monthAttr.selected,e=r.monthAttr.blankTxt,a=r.monthAttr.blankVal,i=0;12>=i;i++){var s="",l=i==t?" selected":"",o=10>i?"0"+i:i,d=r.monthAttr.names[i];0==i&&(d=e,o=a,l=' class="'+r.firstOptionClass+'"'+l),s='<option value="'+o+'"'+l+">"+d+"</option>\n",n+=s}return n},t.fn.dateSelectorYearOptions=function(){var t,e,a,n="";for(t=r.yearAttr.selected,e=r.yearAttr.blankTxt,a=r.yearAttr.blankVal,startYear=parseInt(r.yearAttr.start),0!=t&startYear>t&&(startYear=t),endYear=parseInt(r.yearAttr.end),0!=t&t>endYear&&(endYear=t),i=startYear;endYear>=i;i++){var s="",l=i==t?" selected":"";i==startYear&&(d=e,o=a,firstSelAttr=""==t||"undefined"==typeof t?' class="'+r.firstOptionClass+'" selected':' class="'+r.firstOptionClass+'"',s='<option value="'+o+'"'+firstSelAttr+">"+d+"</option>\n",n+=s);var o=i,d=i;s='<option value="'+o+'"'+l+">"+d+"</option>\n",n+=s}return n},t.fn.dateSelectorAddTimeOptions=function(t,e){var a="";e="undefined"==typeof e?"":e;var n,s,l,o=0,d="";switch(t.toLowerCase()){case"hour":o=23,d=r.hourAttr;break;case"min":o=59,d=r.minAttr;break;case"sec":o=59,d=r.secAttr}n=d.selected,s=d.blankTxt,l=d.blankVal;var c=o+1;for(i=0;o>=i;i++){var b="",k="",m=!1;if(0==i&&(k=n?' class="'+r.firstOptionClass+'"':' class="'+r.firstOptionClass+'" selected',f=s,p=l,b='<option value="'+p+'"'+k+">"+f+"</option>\n",a+=b),m=""==e?!0:m,m="halb"!=e||0!=i&&i!=c/2?m:!0,m="fourth"!=e||0!=i&&i!=c/4&&i!=c/2&&i!=c-c/4?m:!0,m="pair"==e&&i%2==0?!0:m,m="odd"==e&&i%2==1?!0:m){var p=10>i?"0"+i:i,f=10>i?"0"+i:i;k=n==p?" selected":"",b='<option value="'+p+'"'+k+">"+f+"</option>\n",a+=b}}return a},a.css({display:"none",visibility:"hidden"});var n=new Array;n.d=t("<select />",{id:"dateselector_day",name:"dateselector[day]",size:r.dayAttr.size}).addClass(r.dayAttr.class),n.m=t("<select />",{id:"dateselector_month",name:"dateselector[month]",size:r.monthAttr.size}).addClass(r.monthAttr.class),n.y=t("<select />",{id:"dateselector_year",name:"dateselector[year]",size:r.yearAttr.size}).addClass(r.yearAttr.class),n.h=t("<select />",{id:"dateselector_hour",name:"dateselector[hour]",size:r.hourAttr.size}).addClass(r.hourAttr.class),n.i=t("<select />",{id:"dateselector_min",name:"dateselector[min]",size:r.minAttr.size}).addClass(r.minAttr.class),n.s=t("<select />",{id:"dateselector_sec",name:"dateselector[sec]",size:r.secAttr.size}).addClass(r.secAttr.class);var s=a.attr("tabindex");s&&(n.d.attr("tabindex",s),n.m.attr("tabindex",s),n.y.attr("tabindex",s),n.h.attr("tabindex",s),n.i.attr("tabindex",s),n.s.attr("tabindex",s));var l=a.attr("date-value");l=l?l:r.dateformat,l=l.toLowerCase();var o=l.replace(/\W/g,"").split(""),d=l.replace(/\w/g,"").split("");d.push(!1);var c=a.val(),b=c.match(/(\d+)/g);if(""!=c||"undefined"!=typeof c)for(k in b)switch(o[k]){case"d":r.dayAttr.selected=b[k];break;case"m":r.monthAttr.selected=b[k];break;case"y":r.yearAttr.selected=b[k];break;case"h":r.hourAttr.selected=b[k];break;case"i":r.minAttr.selected=b[k];break;case"s":r.secAttr.selected=b[k]}n.d.html(t.fn.dateSelectorDayOptions(31)),n.m.html(t.fn.dateSelectorMonthOptions()),n.y.html(t.fn.dateSelectorYearOptions()),n.h.html(t.fn.dateSelectorAddTimeOptions("hour",r.hourAttr.factor)),n.i.html(t.fn.dateSelectorAddTimeOptions("min",r.minAttr.factor)),n.s.html(t.fn.dateSelectorAddTimeOptions("sec",r.secAttr.factor));var m="",p="";""!=r.dateContainerClass&&""!=r.dateContainerTag&&(m="<"+r.dateContainerTag+' class="'+r.dateContainerClass+'">',p="</"+r.dateContainerTag+">");var f="",A="";""!=r.timeContainerClass&&""!=r.timeContainerTag&&(f="<"+r.timeContainerTag+' class="'+r.timeContainerClass+'">',A="</"+r.timeContainerTag+">");var h=!1,u=!1,y="";for(k in o){var v="",C="",g=n[o[k]];switch(o[k]){case"d":v=r.dateContainerSeparator?r.dayAttr.beforeTag:"",C=r.dateContainerSeparator?r.dayAttr.afterTag:"";break;case"m":v=r.dateContainerSeparator?r.monthAttr.beforeTag:"",C=r.dateContainerSeparator?r.monthAttr.afterTag:"";break;case"y":v=r.dateContainerSeparator?r.yearAttr.beforeTag:"",C=r.dateContainerSeparator?r.yearAttr.afterTag:"";break;case"h":v=r.timeContainerSeparator?r.hourAttr.beforeTag:"",C=r.timeContainerSeparator?r.hourAttr.afterTag:"";break;case"i":v=r.timeContainerSeparator?r.minAttr.beforeTag:"",C=r.timeContainerSeparator?r.minAttr.afterTag:"";break;case"s":v=r.timeContainerSeparator?r.secAttr.beforeTag:"",C=r.timeContainerSeparator?r.secAttr.afterTag:""}"&nbsp;"==C&&"string"==typeof d[k]&&(C+=d[k]);var T="",S="",V=parseInt(k)+1;("d"==o[k]||"m"==o[k]||"y"==o[k])&&(h||(T=m,h=!0)),V<o.length&&(o[V].match(/d|m|y/g)||h&&(S=p,h=!1)),("h"==o[k]||"i"==o[k]||"s"==o[k])&&(u||(T=f,u=!0)),V<o.length&&(o[V].match(/h|i|s/g)||u&&(S=A+"time",u=!1)),y+=T+v+g.get(0).outerHTML+C+S}return a.parent().append(y),t("#"+n.m.attr("id")).change(function(e){e.preventDefault();var a=t(this).val(),s=t("#"+n.y.attr("id")).val(),i=new Date(0,a,0).getDate();return s!=r.yearAttr.blankVal&&(i=new Date(s,a,0).getDate()),t("#"+t(n.d).attr("id")+" option").each(function(){t(this).val()>i?t(this).attr("disabled",!0):t(this).attr("disabled",!1)}),"disabled"==t("#"+n.d.attr("id")+" option:selected").attr("disabled")&&alert(r.alertIncorrectDay),!1}).change(),t(a).parents("form:first").bind("submit",function(e){var s=!0,i=!0,l="",c="",b="";for(k in o){switch(o[k]){case"d":b=t("#"+n.d.attr("id")).val(),blank=b==r.dayAttr.blankVal?!0:!1,valid=b==r.dayAttr.blankVal?!1:!0,c=d[k]!==!1?b+d[k]:b;break;case"m":b=t("#"+n.m.attr("id")).val(),blank=b==r.monthAttr.blankVal?!0:!1,valid=b==r.monthAttr.blankVal?!1:!0,c=d[k]!==!1?b+d[k]:b;break;case"y":b=t("#"+n.y.attr("id")).val(),blank=b==r.yearAttr.blankVal?!0:!1,valid=b==r.yearAttr.blankVal?!1:!0,c=d[k]!==!1?b+d[k]:b;break;case"h":b=t("#"+n.h.attr("id")).val(),blank=b==r.hourAttr.blankVal?!0:!1,valid=b==r.hourAttr.blankVal?!1:!0,c=d[k]!==!1?b+d[k]:b;break;case"i":b=t("#"+n.i.attr("id")).val(),blank=b==r.minAttr.blankVal?!0:!1,valid=b==r.minAttr.blankVal?!1:!0,c=d[k]!==!1?b+d[k]:b;break;case"s":b=t("#"+n.s.attr("id")).val(),blank=b==r.secAttr.blankVal?!0:!1,valid=b==r.secAttr.blankVal?!1:!0,c=d[k]!==!1?b+d[k]:b}s=s&&valid,i=i&&blank,l+=c}return i&&(l=""),r.checkIncomplete&&!s?(e.preventDefault(),alert(r.alertIncomplete),!1):(a.attr("value",l),!0)}).bind("reset",function(){a.attr("value",c)}),!1}}(jQuery);







 var selectClass = 'btn btn-default';	// class of select elements
 var dateOptions = {
     alertIncorrectDay: 'Select a correct day!',	// alert message when bad date is selected (such a month day that doesn't exist)
     alertIncomplete: 'Date incomplete!',		// alert message when incomplete date is selected
     checkIncomplete: false,						// check if date is completed (if true and it's incomplete, alerts before message)

     // date and time group. In this example creates date and time selectors as Bootstrap 3 button groups
     dateContainerTag: 'div',					// container for date selectors
     dateContainerClass: 'btn-group date-group',	// date container class
     dateContainerSeparator: false,				// removes date separators
     timeContainerTag: 'div',					// container for
     timeContainerClass: 'btn-group time-group', // time container class
     timeContainerSeparator: false,				// removes time separators

     // each selector
     dayAttr: {									// day selector attributes
         class:    selectClass,					// applies the same class from the selected input to the day selector
         blankTxt: 'Day: '						// select blank text
     },
     monthAttr: {								// month selector attributes
         class:    selectClass,					// applies the same class from the selected input to the month selector
         blankTxt: 'Month: ',					// select blank text
         names: {								// options values and names (please note that begins at month 1 )
             1: 'January',
             2: 'February',
             3: 'March',
             4: 'April',
             5: 'May',
             6: 'June',
             7: 'July',
             8: 'August',
             9: 'September',
             10: 'October',
             11: 'November',
             12: 'December'
         }
     },
     yearAttr: {									// year selector attributes
         class:    selectClass,					// applies the same class from the selected input to the year selector
         blankTxt: 'Year: '						// select blank text
     },
     hourAttr: {									// hour selector attributes
         class:    selectClass,					// applies the same class from the selected input to the hour selector
         blankTxt: 'Hour: '						// select blank text
     },
     minAttr: {									// minutes selector attributes
         class:    selectClass,					// applies the same class from the selected input to the minute selector
         blankTxt: 'Minutes: ',					// select blank text
         factor:   'fourth' 						// shows only fourth (00, 15, 30, 45) minutes (str options: [halb|fourth|pair|odd])
     },
     secAttr: {									// second selector attributes
         class:    selectClass,					// applies the same class from the selected input to the seconds selector
         blankTxt: 'Seconds: ',					// select blank text
         factor:   '' 							// show al seconds (str options:[halb|fourth|pair|odd])
     }
 };

 // apply dateSelector when document is ready
 $(document).ready(function(){
     // checking if element exists, prevents issues
     if( $('.date_time_input').length > 0)
     {
         $('.date_time_input').dateSelector(dateOptions);
     }
 });



 var _gaq = _gaq || [];
  _gaq.push(['_setAccount', 'UA-36251023-1']);
  _gaq.push(['_setDomainName', 'jqueryscript.net']);
  _gaq.push(['_trackPageview']);

  (function() {
    var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
    ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
  })();










